#if !defined(__limits_h)
#define __limits_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:limits.h	1.26 93/10/26 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/*
 * These symbolic names are defined in the SVID, ANSI C, POSIX, and/or intro(2).
 */

/*
 * [ANSI C] ANSI X3.159-1989 (2.2.4.2.1) Sizes of Integral Types
 */

/* number of bits in a char */
#define	CHAR_BIT	8		
/* max integer value of a char */
#define	SCHAR_MAX	127
#define	UCHAR_MAX	255
#define	CHAR_MAX	SCHAR_MAX
/* min integer value of a char */
#define	SCHAR_MIN	-128
#define	CHAR_MIN	SCHAR_MIN
/* max decimal value of a long */
#define	LONG_MAX	2147483647
/* min decimal value of a long */
#define	LONG_MIN	-2147483648
/* max decimal value of a short */
#define	SHRT_MAX	32767
/* min decimal value of a short */
#define	SHRT_MIN	-32768
/* max decimal value of an int */
#define	INT_MAX		LONG_MAX
/* min decimal value of an int */
#define	INT_MIN		LONG_MIN
/* max decimal value of an unsigned long */
#define	ULONG_MAX	4294967295
/* max decimal value of an unsigned short */
#define	USHRT_MAX	65535
/* max decimal value of an unsigned int */
#define	UINT_MAX	ULONG_MAX
/* max number of bytes in multibyte character, for any supported locale */
#define	MB_LEN_MAX	2

/*
 * operating system constants and other numeric constants not defined by ANSI C;
 * where applicable, cross-referenced to constant and/or file used internally;
 * kconfig(1m)urable values are also cross-referenced to <sys/var.h> and uvar(2)
 */

#if defined(_SYSV_SOURCE)
/*
 * implementation-specific constants defined by SVID, Issue 2
 */

/* max number of of processes per user id; cf. MAXUP <sys/config.h>, v.v_maxup <sys/var.h> */
#define	CHILD_MAX	50
/* max size of a file in bytes; see ULIMIT below */
#define	FCHR_MAX	0		/* overflow! */
/* number of bits in a long */
#define	LONG_BIT	WORD_BIT
/* max number of bytes in terminal input line; cf. CANBSIZ <sys/param.h> */
#define	MAX_CHAR	256
/* max number of characters in a file name; cf. SVFSDIRSIZ <svfs/fsdir.h> */
#define	NAME_MAX	14
/* max value for a process ID; cf. MAXPID <sys/param.h> */
#define	PID_MAX		30000
/* max number of bytes written to a pipe in a write; PIPSIZ <svfs/inode.h> */
#define	PIPE_MAX	8192
/* max number of processes system-wide; cf. NPROC <sys/config.h>, v.v_proc <sys/var.h> */
#define	PROC_MAX	50
/* number of bytes in a physical I/O block; cf. DEV_BSIZE <sys/param.h> */
#define	STD_BLK		512
/* number of chars in uname(2) strings; cf. <sys/utsname.h> */
#define	SYS_NMLN	9
/* max number of open files system-wide; cf. NFILE <sys/config.h>, v.v_file <sys/var.h> */
#define	SYS_OPEN	100
/* max number of unique names generated by tmpnam(3) */
#define	TMP_MAX		17576
/* max value for a user or group ID; cf. MAXUID <sys/param.h> */
#define	UID_MAX		65534
/* max decimal value of an unsigned int */
#define	USI_MAX		ULONG_MAX
/* number of bits in a word (int) */
#define	WORD_BIT	32
/* max pid of system processes */
#define	SYSPID_MAX	2

#if !defined(FLT_DIG)
  /* Number of decimal digits of precision in a float */
#ifndef FLT_DIG
# define FLT_DIG 6
#endif
#endif

#if !defined(FLT_MAX)
  /* Maximum float */
#ifndef FLT_MAX
# define FLT_MAX ((float)3.40282347e+38)
#endif
#endif

#if !defined(FLT_MIN)
  /* Minimum normalised float */
#ifndef FLT_MIN
# define FLT_MIN ((float)1.17549435e-38)
#endif
#endif

#if !defined(DBL_DIG)
  /* Number of decimal digits of precision in a double */
#ifndef DBL_DIG
# define DBL_DIG 15  
#endif
#endif

#if !defined(DBL_MAX)
  /* Maximum double */
#ifndef DBL_MAX
# define DBL_MAX (1.7976931348623157e+308)
#endif
#endif

#if !defined(DBL_MIN)
  /* Minimum normalised double */
#ifndef __STDC__
#ifndef DBL_MIN
# define DBL_MIN (2.2250738585072018e-308)
#endif
#else
#ifndef DBL_MIN
# define DBL_MIN (2.2250738585072014e-308)
#endif
#endif
#endif

#if !defined(MAXDOUBLE)
# define MAXDOUBLE	DBL_MAX
#endif

#endif /* _SYSV_SOURCE */

#if defined(_POSIX_SOURCE)
/*
 * minimum values for implementation-specific constants defined by POSIX.1
 */
#define	_POSIX_ARG_MAX		4096
#define	_POSIX_CHILD_MAX	6
#define	_POSIX_LINK_MAX		8
#define	_POSIX_MAX_CANON	255
#define	_POSIX_MAX_INPUT	255
#define	_POSIX_NAME_MAX		14
#define	_POSIX_NGROUPS_MAX	0
#define	_POSIX_OPEN_MAX		16
#define	_POSIX_PATH_MAX		255
#define	_POSIX_PIPE_BUF		512
#define	_POSIX_SSIZE_MAX	32767
#define	_POSIX_STREAM_MAX	8
#define	_POSIX_TZNAME_MAX	3

/*
 * implementation-specific constants defined by POSIX.1
 */
/*
 * POSIX requires indeterminate values to be omitted;
 * CHILD_MAX is the equivalent of the kconfig(1m)able paramter MAXUP;
 * use sysconf() to obtain a value for CHILD_MAX
 */
#if defined(CHILD_MAX)
#undef	CHILD_MAX
#endif	/* CHILD_MAX */
/*
 * POSIX requires indeterminate values to be omitted;
 * NAME_MAX is filesystem dependent;
 * use pathconf() to obtain a value for NAME_MAX
 */
#if defined(NAME_MAX)
#undef	NAME_MAX
#endif	/* NAME_MAX */
/* max number of supplementary group IDs; cf. NGROUPS <sys/param.h> */
#define	NGROUPS_MAX	8
/* max number of bytes in canonical input line; cf. CANBSIZ <sys/param.h> */
#define	MAX_CANON	256
/* max number of bytes in terminal input queue; cf. CANBSIZ <sys/param.h> */
#define	MAX_INPUT	256
/* max value storable in object of type ssize_t */
#define	SSIZE_MAX	INT_MAX
/* max number of standard I/O streams open per process; cf. _NFILE <stdio.h> */ 
#define STREAM_MAX	128
/* max number of bytes in a timezone name; cf. TZ_MAX_CHARS <tzfile.h> */
#define TZNAME_MAX	50
#endif /* _POSIX_SOURCE */

#if defined(_SYSV_SOURCE) || defined(_POSIX_SOURCE)
/*
 * implementation-specific constants defined by SVID 2 and POSIX.1 
 */

/* max length of arguments to exec(2); cf. NCARGS <sys/param.h> */
#define	ARG_MAX		20480
/* max number of links per file; cf. MAXLINK <sys/param.h> */
#define	LINK_MAX	SHRT_MAX
/* max number of open files per process; cf. NOFILE <sys/param.h> */
#define	OPEN_MAX	128	
/* max number of characters in a path name; cf. MAXPATHLEN <sys/param.h> */
#define	PATH_MAX	1024
/* max number of bytes atomic in write to a pipe; PIPSIZ <svfs/inode.h> */
#define	PIPE_BUF	8192
#endif /* _SYSV_SOURCE || _POSIX_SOURCE */

#if defined(_SYSV_SOURCE) || defined(_FIPS_151_SOURCE)
/*
 * implementation-specific constants defined by SVID 2 and initial POSIX FIPS
 */

/*
 * CLK_TCK is also defined in <time.h>, for historical reasons.
 * number of of clock ticks per second; cf. HZ and CLKTICK <sys/param.h>
 */
#if !defined(CLK_TCK)
#define	CLK_TCK		60
#endif /* !CLK_TCK */
/* max number of characters in a password */
#define	PASS_MAX	8
/* max value for a process ID; cf. MAXPID <sys/param.h> */
#define	PID_MAX		30000
/* max value for a user or group ID; cf. MAXUID <sys/param.h> */
#define	UID_MAX		65534
#endif /* _SYSV_SOURCE || _FIPS_151_SOURCE */

#if defined(_AUX_SOURCE)
/*
 * implementation-specific constants defined by A/UX in intro(2)
 */

/* max size of file in 512-byte blocks; cf. CDLIMIT <sys/param.h>, ulimit(2) */
#define	ULIMIT		16777216
#endif /* _AUX_SOURCE */

#endif /* __limits_h */
