#if !defined(__sys_uinter_h)
#define __sys_uinter_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/uinter.h	1.60 93/10/06 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/*
 *	User interface 'driver' version number
 */
#define	UI_VERSION	5		/* driver version gets bumped when */
					/* driver interface changes */
/*
 *	System configuration constants
 */
#define NDEVICES	1		/* number of uinter devices supported */
					/* for NDEVICES > 1, we must solve */
					/* screen/mouse/keyboard -> device */
					/* mapping problem */
#define NATTACHES       16              /* number of procs attached per layer */
#define	NLAYERS		1		/* number of layers/device */
#define	NEVENTS		32		/* number of events/layer */

/*
 *	User interface 'driver' ioctls etc
 */
#define UI_GETVERSION	_IO('Q',0)	/* get driver version */
#define	UI_SET		_IO('Q',1)	/* set the a-line trap handler */
#define	UI_CLEAR	_IO('Q',2)	/* clear the a-line trap handler */
#define	UI_UNSCREEN	_IO('Q',4)	/* unphys in the screens */
#define	UI_ROM		_IO('Q',5)	/* phys in the ROM
					   1 parameter - virtual address
					   on a segment boundary */
#define	UI_UNROM	_IO('Q',6)	/* unphys in the ROM */
#define	UI_MAP		_IO('Q',7)	/* map in and lock down a page
					   in a shared memory segment
					   to be used for cursor stuff
					   max of 1 page per 'device'
					   open */
#define	UI_UNMAP	_IO('Q',8)	/* undo this */
#define	UI_CURSOR	_IO('Q',9)	/* start display of cursor on vertical
					   retrace */
#define	UI_UNCURSOR	_IO('Q',10)	/* turn it back off */
#define UI_PHYS         _IOW('Q',11,struct ui_phys)
#define	UI_DELAY	_IOWR('Q',12,long)/* delay n ticks and return the
					   number of ticks since booting */
#define	UI_POSTEVENT	_IOW('Q',16,struct postevent)/* post an event to our
						      layer */
#define	UI_LPOSTEVENT	_IOW('Q',17,struct lpostevent)/* post an event to a
						       named layer */
#define	UI_FLUSHEVENTS	_IOW('Q',18,struct flushevents)/* flush events from
						        our layer */
#define	UI_GETOSEVENT	_IOWR('Q',19,struct getosevent)	/* get an event */
#define	UI_SETEVENTMASK	_IOW('Q',20,short)/* set the layer event mask */
#define	UI_CREATELAYER	_IO('Q',21)	/* create a layer */
#define	UI_UNLAYER	_IO('Q',22)	/* kill a layer */
#define	UI_SETLAYER	_IOW('Q',23,int)	/* set the currently active layer */
#define	UI_DEVICES	_IO('Q',24)	/* turn the keyboard/mouse on */
#define	UI_UNDEVICES	_IO('Q',25)	/* turn the keyboard/mouse off */
#define UI_SETSELRECT	_IOW('Q',26,Rect)	/* set select's mouse rect */
#define UI_HASKIDS	_IOW('Q',27,int)	/* find out about a procs children */
#define UI_READPRAM	_IOW('Q',28,struct pram)/* read parameter RAM */
#define UI_WRITEPRAM	_IOW('Q',29,struct pram)/* write parameter RAM */
#define	UI_POST_MOD	_IOW('Q',30,EventRecord)/* post an event & modifiers
							to our layer */
#define	UI_FIND_EVENT	_IOWR('Q',31,struct findevent)/* post an event & modifiers
							to our layer */
#define UI_COPY_OUT	_IOW('Q',32,struct lm_element)	/* copy a low memory
							   region from kernel
							   to user */
#define UI_PUSHLAYER	_IO('Q',33)	/* bring another layer in front of this one */

#define UI_PHYS_SCREENS	_IOWR('Q',34,struct screens)	/* map in screens */

#define	UI_TIMER	_IOWR('Q',35,long)/* set timer to go off in n ticks
					   return number of ticks left on
					   current timer - if timer goes off
					   generate a SIGSEGV */
#define	UI_ATTACHGFD	_IO('Q',36)	/* attach global file descriptor table */
#define	UI_ATTACHLAYER	_IOW('Q',37,struct attachInfo)
#define UI_SWITCH       _IOW('Q',38,int)
#define UI_SLEEP        _IO('Q',39)
#define UI_SELECT       _IOW('Q',40,struct select)
#define UI_GETTASKID    _IOR('Q',41,long)
#define UI_GETDQEL      _IOWR('Q',42,struct DrvQEl)     /* get 1 Mac DrvQEl */
#define UI_KILLMYLAYER  _IO('Q',43)
#define UI_REBOOT       _IO('Q',44)
#define UI_SHUTDOWN     _IO('Q',45)
#define	UI_SHMID	_IOW('Q',46,int)
#define	UI_VIDEO_CONTROL _IOWR('Q',47,struct CntrlParam)
#define	UI_VIDEO_STATUS  _IOWR('Q',48,struct CntrlParam)
#define	UI_SYNC         _IOW('Q',50,int)
#define	UI_SET_KCHR	_IOW('Q',51,struct kybd_map)
#define	UI_TEST         _IOW('Q',52,int)

/* VU/Mole */
#define UI_MOUSE	_IOW('Q',53,struct mouse_info)	/* force mouse */
#define	UI_KEYBOARD	_IOW('Q',54,char)		/*force keycode */

#define	UI_POST_EVTREC	_IOW('Q',55,EventRecord)        /* post an entire event
							  record to our layer */
#define UI_GETKIFLAGS	_IOR('Q',56,unsigned short)   /* kernel_info.ki_flags */

/* 7.0 VM Calls */
#define UI_VM_HOLDMEM	_IOW('Q',57,struct vm_lock)
#define UI_VM_UNHOLDMEM	_IOW('Q',58,struct vm_lock)
#define UI_VM_LOCKMEM	_IOW('Q',59,struct vm_lock)
#define UI_VM_UNLOCKMEM	_IOW('Q',60,struct vm_lock)
#define UI_VM_LOCKMEMCONTIGUOUS	_IOW('Q',61,struct vm_lock)
#define UI_VM_GETPHYS	_IOWR('Q',62,struct vm_phys)

#define UI_SETCOFFNAME	_IOWR('Q',63,struct coffname)	/* set coff name */
#define UI_GETCOFFNAME	_IOWR('Q',64,struct coffname)	/* get coff name */
#define UI_PUTDQEL      _IOWR('Q',65,struct DrvQEl)	/* add 1 Mac DrvQEl */
#define UI_DELDQEL      _IOWR('Q',66,struct DrvQEl)	/* rem 1 Mac DrvQEl */
#define UI_GET_PRODINFO _IO('Q',67)			/* get ProductInfo */
#define UI_GET_INTERR_VECTORS _IO('Q',68)   /* get saved Mac Fl Pt exc vecs.*/

typedef char keyarray_t[128];
#define UI_GETKEYS	_IO('Q',69)	    /* get keyboard state */

#define UI_GETSCSIID	_IO('Q', 70)	/* get mac first 7 SCSI devices */
#define UI_SCANSCSI	_IO('Q', 71)	/* scan SCSI buses to find devices */

/*
 *	Defines for eventmanager stuff
 */
#define attachEvt       16
#define exitEvt         17
#define selEvt          18
#define waitEvt         31            /* reserve dummy event for timeout condition */
#define	waitMask	0x80000000    /* sleeping in WaitNextEvent */
#define AUX_EVENT_MASK  0x7fff0000

/*
 *	Parameters for ioctls
 */

struct postevent {
	unsigned short	eventCode;
	unsigned long	eventMsg;
};

struct lpostevent {
	unsigned short	layer;
	unsigned short	eventCode;
	unsigned long	eventMsg;
};

struct flushevents {
	unsigned short	eventMask;
	unsigned short	stopMask;
};

struct getosevent {
	char		blocking;
	char            auxevents;
	short		eventMask;
	EventRecord	theEvent;
	unsigned long	timeOut;
	Rect		mouseRect;
};

struct drive_queue {
	long		flags;
	DrvQEl		theQueue;
};

struct findevent {
	EventRecord	mask;
	EventRecord	data;
};

struct pram {
	char		*buffer;
	long		count;
};

struct state {
	unsigned char	state;
	char		wanted;
};

struct daemon {
	struct state	l[NLAYERS];
};

struct screen {
	char		dCtlSlot;
	char		dCtlSlotId;
	char		dCtlExtDev;
	long		dCtlDevBase;
};

#define INVALID_SLOT	-1

struct screens {
	struct screen	screen[NSCREENS];
};

struct lm_element {
	caddr_t		start_address;
	unsigned long	byte_count;
};

struct kybd_map {
	caddr_t		base_address;
	unsigned long	byte_count;
};

struct mouse_info {
	unsigned long	mouse_x;
	unsigned long	mouse_y;
	unsigned char	mouse_button;
};

struct vm_lock {
	caddr_t		address;
	unsigned long	count;
};

struct vm_phys {
	struct LogicalToPhysicalTable *table;
	unsigned long entrycount;
};

struct coffname {
	long    taskid;
	char    *path;
	short   pathlen;
};

/*
 *	Values for 'blocking' 
 */

#define NOBLOCK		0	/* don't block, return instead */
#define BLOCK		1	/* block until event, timeout or mouse moves */
#define AVAIL		2	/* don't block or remove event */
#define AVBLOCK         3       /* block until event, timeout or mouse moves */
                                /* but don't remove the event */

/*
 *	Values for 'wanted'
 */

#define NOTHING_WANTED	0	/* the layer never wanted anything */
#define C_WANTED	1	/* the layer asked for cursor tracking */
#define A_WANTED	2	/* the layer asked for mouse/keyboard events */
#define PHANTOM_FLAG	4	/* tells the phantom to refresh screen */


struct ui_phys {
        char         *vaddr;
	char         *paddr;
	unsigned long size;
};

struct select {
	int          nfd;
	int          mask[3];
};

struct attachInfo {
        int          layerid;
	int          size;
	short        flags;
};


#ifdef KERNEL

/*
 *	An event descriptor
 */

struct event {
	struct event 		*next;	/* next event in the list */
	EventRecord		event;	/* the event record */
};


struct attach {
        struct proc  *procp;
	struct select select;
	short         pid;
	char          brkselect;
	char	      romid;			/* phys id for ROM */
						/* phys ids for each screen */
	char	      screenid[NSCREENS];	/* 32-bit addr; 32-bit tree */
	char	      screenid32[NSCREENS];	/* 24-bit addr; 32-bit tree */
	char	      screenid24[NSCREENS];	/* 24-bit addr; 24-bit tree */
	char	      screenidRBV;		/* screen id for RBV hack */
	char	     *savedusp;
};	

struct scrninfo {
	caddr_t       vaddr;
	caddr_t       paddr;
	unsigned long size;
};

typedef struct scrninfo scrninfo;


/*
 *	A layer structure descriptor
 */
struct layer {
	struct state	l_state;	/* state of this layer */
	char		l_update;	/* an update event is waiting */
	char		l_down;		/* true when a char is down and may
					   auto-repeat */
	char		l_char;		/* the char that is down */
	char		l_timeout;	/* set when a timeout is pending */
	long		l_time;		/* when the char will be repeated */
	struct event	*l_first;	/* first event in the list */
	struct event	*l_last;	/* last event in the list */
	struct event	*l_free;	/* first free entry in the list */
	long		l_mask;		/* layer event mask */
	long		l_sleep;	/* events being slept for */
	Rect		l_mouse;	/* mouseRect for WaitNextEvent */
	Rect		l_selmouse;	/* mouseRect for select() */
	struct attach   *l_active;
	unsigned long   l_prevtime;
	int             l_trunning;
	unsigned long   l_wakeme;
	int             l_shmid;
	struct file    **l_gofptr;
	char            *l_gpfptr;
	short           l_refcnt;
	short           l_killed;
	caddr_t         l_romaddr;      /* virt addr at which ROM is attached */
	caddr_t         l_lowaddr;
	scrninfo 	l_screen[NSCREENS];	/* 32-bit address */
	scrninfo	l_screen24[NSCREENS];	/* 24-bit address */
	scrninfo	l_screenRBV;		/* RBV hack */
	struct event	l_events[NEVENTS];	/* The event queue */
	struct attach   l_attached[NATTACHES];
	struct proc    *l_processes[NATTACHES];
	int             l_maxproc;
};


/*
 *	Layer states
 */

#define	LS_EMPTY	0	/* available */
#define	LS_DONE		1	/* finished with */
#define	LS_INUSE	2	/* someone is using it */


/*
 *	These defines are for picking apart the word in the UDOT that
 *	specifies which device, and which layer the process is attached
 *	to
 */

#define	UI_FLAG		0x8000		 /* This process is attached to a
					    user interface */
#define	UI_DEVICE(x)	(((x)>>8)&0x7f)	 /* The user interface device we are
					    connected to */
#define	UI_DL(x)	(((x)<<8)&0x7f00)/* the inverse of above */
#define	UI_LAYER(x)	((x)&0xff)	 /* The user interface layer we are
					    connected to */
#define UI_SETID(x)     (((x)<<16)&0xff0000)
#define UI_GETID(x)     (((x)>>16)&0xff)


#endif


#define NOLAYER 	0xff		 /* no layer */


/*
 *	Warning: offsets in this data structure are referenced in
 *		 uinters.s
 */

struct ui_interface {
	unsigned long	c_mx;	/* x mouse position */
	unsigned long	c_my;	/* y mouse position */
	unsigned long	c_cx;	/* x cursor position */
	unsigned long	c_cy;	/* y cursor position */
	unsigned long	c_smx;	/* x screen row size in pixels */
	unsigned long	c_smy;	/* y screen row size in pixels */
	unsigned long	c_ssx;	/* x visible screen size in pixels */
	unsigned long	c_ssy;	/* y visible screen size in pixels */
	unsigned long	c_hpx;	/* x mouse hotpoint offset */
	unsigned long	c_hpy;	/* y mouse hotpoint offset */
	char           *c_cursor;
	unsigned short	c_mask[16];	/* the cursor mask */
	union cursor {
		short small1[16*16/16];	   /* 0: 16x16 cursor  1 b/p*/
		long  small2[16*16*2/32];  /* 1: 16x16 cursor  2 b/p */
		long  small4[16*16*4/32];  /* 2: 16x16 cursor  4 b/p */
		long  small8[16*16*8/32];  /* 3: 16x16 cursor  8 b/p */
		long  small16[16*16*16/32];/* 4: 16x16 cursor 16 b/p */
		long  small32[16*16*32/32];/* 5: 16x16 cursor 32 b/p */
	}		c_data;		/* what was under the cursor */	
	unsigned long	c_style;	/* cursor style (large/small) (1/8) */
	unsigned long   c_newcrsr;
	unsigned long	c_lock;		/* cursor lock */
	unsigned char	c_button;	/* current mouse button state */
	unsigned short	c_modifiers;	/* command modifiers */
	unsigned short	c_mlookup[10];	/* mouse lookup table */
	unsigned short	c_keythres;	/* auto key threshold (in ticks) */
	unsigned short  c_keyrate;	/* auto key rate (in ticks) */
					/* this structure will move into it's own */
					/* segment when I really do multi-layers */
};

/*
 *	Cursor styles
 */

#define	CUR_SMALL1	0		/* 0: 16x16 cursor  1 b/p */
#define	CUR_SMALL2	1		/* 1: 16x16 cursor  2 b/p */
#define	CUR_SMALL4	2		/* 2: 16x16 cursor  4 b/p */
#define	CUR_SMALL8	3		/* 3: 16x16 cursor  8 b/p */
#define	CUR_SMALL16	4	        /* 4: 16x16 cursor 16 b/p */
#define	CUR_SMALL32	5		/* 5: 16x16 cursor 32 b/p */

#endif /* __sys_uinter_h */
