#if !defined(__sys_stat_h)
#define __sys_stat_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/stat.h	1.20 93/02/04 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif

/*
 * Structure of the result of stat
 */
#ifdef _POSIX_SOURCE
struct	stat
{
	dev_t		st_dev;
	short		st_spare0;
	mode_t		st_mode;
	nlink_t		st_nlink;
	int		st_spare1;
	dev_t		st_rdev;
	off_t		st_size;
	time_t		st_atime;
	ino_t		st_ino;
#ifdef _AUX_SOURCE
#define	st_inol		st_ino		/* backwards compatibility */
#endif /* _AUX_SOURCE */
	time_t		st_mtime;
	int		st_spare2;
	time_t		st_ctime;
	int		st_spare3;
	long		st_blksize;
	long		st_blocks;
	uid_t		st_uid;
	gid_t		st_gid;
};
#else /* !_POSIX_SOURCE */
struct	stat
{
	dev_t		st_dev;
	ino_t		st_ino;
	mode_t		st_mode;
	nlink_t		st_nlink;
	ushort_t	st_uid;
	ushort_t	st_gid;
	dev_t		st_rdev;
	off_t		st_size;
	time_t		st_atime;
#ifdef _AUX_SOURCE
	ino_tl		st_inol;
#else /* !_AUX_SOURCE */
	ulong_t		st_inol;
#endif /* _AUX_SOURCE */
	time_t		st_mtime;
	int		st_spare2;
	time_t		st_ctime;
	int		st_spare3;
	long		st_blksize;
	long		st_blocks;
	long		st_spare4[2];
};
#endif /* _POSIX_SOURCE */


#ifndef STANDALONE
#define XINFOSIZ        9

#ifdef _POSIX_SOURCE
struct	xstat
{
	dev_t		st_dev;
	short		st_spare0;
	mode_t		st_mode;
	nlink_t		st_nlink;
	int		st_spare1;
	dev_t		st_rdev;
	off_t		st_size;
	time_t		st_atime;
	ino_t		st_ino;
#ifdef _AUX_SOURCE
#define	st_inol		st_ino		/* backwards compatibility */
#endif /* _AUX_SOURCE */
	time_t		st_mtime;
	int		st_spare2;
	time_t		st_ctime;
	int		st_spare3;
	long		st_blksize;
	long		st_blocks;
	uid_t		st_uid;
	gid_t		st_gid;

	int             st_xerror;
	long            st_xinfo[XINFOSIZ];
};
#else /* !_POSIX_SOURCE */
struct	xstat
{
	dev_t		st_dev;
	ino_t		st_ino;
	mode_t		st_mode;
	nlink_t		st_nlink;
	ushort_t	st_uid;
	ushort_t	st_gid;
	dev_t		st_rdev;
	off_t		st_size;
	time_t		st_atime;
#ifdef _AUX_SOURCE
	ino_tl		st_inol;
#else /* !_AUX_SOURCE */
	ulong_t		st_inol;
#endif /* _AUX_SOURCE */
	time_t		st_mtime;
	int		st_spare2;
	time_t		st_ctime;
	int		st_spare3;
	long		st_blksize;
	long		st_blocks;
	long		st_spare4[2];

	int             st_xerror;
	long            st_xinfo[XINFOSIZ];
};
#endif /* _POSIX_SOURCE */
#endif



#define	S_ISUID		04000		/* set user id on execution */
#define	S_ISGID		02000		/* set group id on execution */
/* additional (historical) file modes */
#define	S_ISVTX		01000		/* save swapped text even after use */
#define	S_IREAD		00400		/* read permission, owner */
#define	S_IWRITE	00200		/* write permission, owner */
#define	S_IEXEC		00100		/* execute/search permission, owner */

/* historical file type constants */
#define	S_IFMT	0170000			/* type of file */
#define		S_IFIFO		0010000	/* fifo */
#define		S_IFCHR		0020000	/* character special */
#define		S_IFDIR		0040000	/* directory */
#define		S_IFBLK		0060000	/* block special */
#define		S_IFREG		0100000	/* regular */
/* additional BSD file types */
#define		S_IFLNK		0120000	/* symbolic link */
#define		S_IFSOCK	0140000	/* socket */

#define	S_ISFIFO(m)	(((m) & S_IFMT) == S_IFIFO)
#define	S_ISCHR(m)	(((m) & S_IFMT) == S_IFCHR)
#define	S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)
#define	S_ISBLK(m)	(((m) & S_IFMT) == S_IFBLK)
#define	S_ISREG(m)	(((m) & S_IFMT) == S_IFREG)
#define	S_ISLNK(m)	(((m) & S_IFMT) == S_IFLNK)
#define	S_ISSOCK(m)	(((m) & S_IFMT) == S_IFSOCK)

#if defined(_SYSV_SOURCE) || defined(_POSIX_SOURCE)
#define	S_IRUSR		00400		/* read permission, owner */
#define	S_IWUSR		00200		/* write permission, owner */
#define	S_IXUSR		00100		/* execute/search permission, owner */
#define	S_IRWXU		(S_IRUSR | S_IWUSR | S_IXUSR)

#define	S_IRGRP		00040		/* read permission, group */
#define	S_IWGRP		00020		/* write permission, group */
#define	S_IXGRP		00010		/* execute/search permission, group */
#define	S_IRWXG		(S_IRGRP | S_IWGRP | S_IXGRP)

#define	S_IROTH		00004		/* read permission, other */
#define	S_IWOTH		00002		/* write permission, other */
#define	S_IXOTH		00001		/* execute/search permission, other */
#define	S_IRWXO		(S_IROTH | S_IWOTH | S_IXOTH)
#endif /* _SYSV_SOURCE || _POSIX_SOURCE */

#if defined(_POSIX_SOURCE)

#if defined(__STDC__)
  int chmod(const char *path, mode_t mode);
  int fstat(int fildes, struct stat *buf);
  int mkdir(const char *path, mode_t mode);
  int mkfifo(const char *path, mode_t mode);
  int stat(const char *path, struct stat *buf);
  mode_t umask(mode_t mask);
#else
  int chmod(), fstat(), mkdir(), mkfifo(), stat();
  mode_t umask();
#endif /* __STDC__ */

#endif /* _POSIX_SOURCE */
#endif /* __sys_stat_h */
#if defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__)
extern int lstat (const char *, struct stat *);
#endif /* defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__*/
