#if !defined(__sys_signal_h)
#define __sys_signal_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/signal.h	1.10 91/06/02 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */

/*
 * [ANSI C] ANSI X3.159-1989 (4.7) Signal Handling
 * [POSIX]  IEEE Std 1003.1-1988 (3.3) Signals
 */

/*
 * Signal names defined by ANSI C, POSIX and historical implementations.
 * First argument to signal().
 */

#define	SIGHUP		1	/* hangup */
#define	SIGINT		2	/* interrupt (rubout) */
#define	SIGQUIT		3	/* quit (ASCII FS) */
#define	SIGILL		4	/* illegal instruction (not reset when caught)*/
#define	SIGTRAP		5	/* trace trap (not reset when caught) */
#define	SIGIOT		6	/* IOT instruction */
#define	SIGABRT		SIGIOT	/* abnormal termination, e.g., from abort() */
#define	SIGEMT		7	/* EMT instruction */
#define	SIGFPE		8	/* floating point exception */
#define	SIGKILL		9	/* kill (cannot be caught or ignored) */
#define	SIGBUS		10	/* bus error */
#define	SIGSEGV		11	/* segmentation violation */
#define	SIGSYS		12	/* bad argument to system call */
#define	SIGPIPE		13	/* write on a pipe with no one to read it */
#define	SIGALRM		14	/* alarm clock */
#define	SIGTERM		15	/* software termination signal from kill */
#define	SIGUSR1		16	/* user defined signal 1 */
#define	SIGUSR2		17	/* user defined signal 2 */
#define	SIGCLD		18	/* death of a child */
#define	SIGCHLD		SIGCLD	/* death of a child (System V style) */
#define	SIGPWR		19	/* power-fail restart */
#define	SIGTSTP		20	/* stop signal from tty */
#define	SIGTTIN		21	/* to readers pgrp upon background tty read */
#define	SIGTTOU		22	/* like TTIN for output if TOSTOP set */
#define	SIGSTOP		23	/* sendable stop signal not from tty */
#define	SIGXCPU		24	/* exceeded CPU time limit */
#define	SIGXFSZ		25	/* exceeded file size limit */
#define	SIGVTALRM	26	/* virtual time alarm */
#define	SIGPROF		27	/* profiling time alarm */
#define	SIGWINCH	28	/* window changed */
#define	SIGCONT		29	/* continue a stopped process */
#define	SIGURG		30	/* urgent condition on IO channel */
#define	SIGIO		31	/* input/output possible signal */

/*
 * Resolve conflicting definitions for return value and arguments of signal().
 */

#if defined(__STDC__)
  typedef void (*sigfunc_t)(int);
#elif defined(_POSIX_SOURCE)
  typedef void (*sigfunc_t)();
#else
  typedef int (*sigfunc_t)();
#endif

/*
 * Signal actions; second argument to signal()
 */
#define	SIG_DFL		(sigfunc_t) 0	/* default signal handling request */
#define	SIG_ERR		(sigfunc_t) -1	/* error return value */
#define	SIG_IGN		(sigfunc_t) 1	/* ignore signal request */

#if defined(_SYSV_SOURCE) || defined(_BSD_SOURCE)
# define NSIG 32
#endif /* _SYSV_SOURCE || _BSD_SOURCE */

#ifdef _BSD_SOURCE
  /* SIGFPE codes */
# define KINTOVF		1	/* integer overflow */
# define KINTDIV		2	/* integer divide by zero */
# define KFLTOVF		3	/* floating overflow */
# define KFLTDIV		4	/* floating divide by zero */
# define KDECDIV		KFLTDIV	/* decimal divide by zero */
# define KFLTUND		5	/* floating underflow */
# define KDECOVF		6	/* decimal overflow */
# define KSUBRNG		7	/* subscript range */

  /*
   * Signal vector "template" used in sigvec call.
   */
  struct sigvec {
	sigfunc_t sv_handler;	/* signal handler */
	int	  sv_mask;	/* signal mask to apply */
	int	  sv_flags;	/* signal handling flags */
  };

# define SV_ONSTACK	0x0001	/* take signal on signal stack */
# define SV_INTERRUPT	0x0002	/* do not restart syscalls on sig return */
# define SV_NOCLDSTOP	0x0010	/* inhibit SIGCHLD when children stop */
# define sv_onstack     sv_flags /* isn't compatibility wonderful! */

  /*
   * Structure used in sigstack call.
   */
  struct sigstack {
	char	*ss_sp;		/* signal stack pointer */
	int	ss_onstack;	/* current status */
  };

  /*
   * Information pushed on stack when a signal is delivered.
   * This is used by the kernel to restore state following
   * execution of the signal handler.  It is also made available
   * to the handler to allow it to properly restore state if
   * a non-standard exit is performed.
   */
  struct sigcontext {
	int	sc_onstack;		/* sigstack state to restore */
	int	sc_mask;		/* signal mask to restore */
	int	sc_sp;			/* sp to restore */
	int	sc_pc;			/* pc to retore */
	int	sc_ps;			/* psl to restore */
  };

# define BADSIG          SIG_ERR
# define SIG_CATCH	(sigfunc_t) 2
# define SIG_HOLD	(sigfunc_t) 3

  /*
   * Macro for converting signal number to a mask suitable for
   * sigblock().
   */
# define sigmask(m)	(1 << ((m)-1))
#endif /* _BSD_SOURCE */

# if (__STDC__ != 1) || defined(_POSIX_SOURCE)

# if !defined(_SIGSET_T) && !defined(__sigset_t__)
#   define  _SIGSET_T			/* make AT&T happy */
#   define  __sigset_t__		/* make MPW happy */
    typedef int sigset_t;
# endif

  /* corollary to struct sigvec */
  struct sigaction {
	sigfunc_t sa_handler;	/* SIG_DFL, SIG_IGN, or pointer to function */
	sigset_t sa_mask;	/* set of signals to be blocked in function */
	int sa_flags;		/* special flags: SA_NOCLDSTOP and others */
  };

  /* sigaction.sa_flags values */
# define SA_ONSTACK	0x0001	/* take signal on signal stack */
# define SA_INTERRUPT	0x0002	/* do not restart system on signal return */
# define SA_NOCLDSTOP	0x0010	/* inhibit SIGCHLD when children stop */

  /* sigprocmask(how, ...) values */
# define SIG_BLOCK	0x0001	/* logical OR of current mask and new set */
# define SIG_UNBLOCK	0x0002	/* logical AND of current mask and new set */
# define SIG_SETMASK	0x0004	/* new set */

#endif /* __STDC__ != 1 || _POSIX_SOURCE */

#endif /* __sys_signal_h */
