#if !defined(__sys_oss_h)
#define __sys_oss_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/oss.h	1.9 91/07/10 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif 

/*
 * oss.h			OSS chip defines
 */

#define OSS_ADDR		0x50f1a000

#ifndef LOCORE
struct oss {
    u_char oss_intlev[0x10];	/* [0x000-0x00f] Interrupt levels */
    u_char filler[0x1F2];	/* [0x010-0x201] IO space filler */
    u_short oss_intpnd;		/* [0x202-0x203] pending interrupts bits */
    u_char oss_rcr;		/* [0x204-0x204] ROM cntl reg (for poweroff) */
    u_char unused[0x2];		/* [0x205-0x206] currently unused by A/UX */
    u_char oss_60hz_ack;	/* [0x207-0x207] 60 Hz ack. */
};
#endif

/*
 * Interrupt level offsets for oss_intlev.
 */
#define OSS_NUBUS0	0
#define OSS_NUBUS1	1
#define OSS_NUBUS2	2
#define OSS_NUBUS3	3
#define OSS_NUBUS4	4
#define OSS_NUBUS5	5
#define OSS_IOPISM	6
#define OSS_IOPSCC	7
#define OSS_SOUND	8
#define OSS_SCSI	9
#define OSS_60HZ	10
#define OSS_VIA1	11
#define OSS_UNUSED1	12
#define OSS_UNUSED2	13
#define OSS_PARITY	14
#define OSS_UNUSED3	15

/*
 * Pending interrupt bits (oss_intpnd).
 */
#define OSS_IP_NUBUS0	0x0001
#define OSS_IP_NUBUS1	0x0002
#define OSS_IP_NUBUS2	0x0004
#define OSS_IP_NUBUS3	0x0008
#define OSS_IP_NUBUS4	0x0010
#define OSS_IP_NUBUS5	0x0020
#define OSS_IP_IOPISM	0x0040
#define OSS_IP_IOPSCC	0x0080
#define OSS_IP_SOUND	0x0100
#define OSS_IP_SCSI	0x0200
#define OSS_IP_60HZ	0x0400
#define OSS_IP_VIA1	0x0800
#define OSS_IP_UNUSED1	0x1000
#define OSS_IP_UNUSED2	0x2000
#define OSS_IP_PARITY	0x4000
#define OSS_IP_UNUSED3	0x8000

/*
 * Rom Control Register
 */
#define OSS_POWEROFF	0x80

/*
 * OSS Interrupt levels for various sub-systems
 */
#define OSS_INTLEV_DISABLED	0
#define OSS_INTLEV_60HZ		1
#define OSS_INTLEV_IOPISM	1
#define OSS_INTLEV_VIA1		1
#define OSS_INTLEV_SOUND	2
#define OSS_INTLEV_SCSI		2
#define OSS_INTLEV_NUBUS	2
#define OSS_INTLEV_IOPSCC	4
#define OSS_INTLEV_PARITY	7

#endif /* __sys_oss_h */
