#if !defined(__sys_mount_h)
#define __sys_mount_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/mount.h	1.12 91/07/10 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1983-87 Sun Microsystems, Inc. */
/* Copyright 1980-87 The Regents of the University of California */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif 

/* NFSSRC 2.1 86/04/11 */

/*
 * mount options
 */
#define M_RDONLY	0x01	/* mount fs read only */
#define M_NOSUID	0x02	/* mount fs with setuid not allowed */
#define M_NEWTYPE	0x04	/* use type string (PLACEHOLDER) */
#define M_GRPID		0x08	/* Old BSD group-id on create */
#define M_REMOUNT	0x10	/* change options on existing mount */
#define M_NOSUB		0x20	/* Disallow mounts beneath this mount */
#define M_MULTI		0x40	/* Do multi-component lookup on files */

/*
 * File system types, these correspond to entries in vfssw
 */
#define	MOUNT_SVFS	0		/* Sys V file system */
#define	MOUNT_NFS	1		/* NFS file system */
#define	MOUNT_PC	2		/* PC NFS file system */
#define	MOUNT_UFS	3		/* BSD fast file system */
#define MOUNT_LO	4
#define	MOUNT_USER1	5		/* User defined file system */
#define	MOUNT_USER2	6		/* User defined file system */
#define	MOUNT_USER3	7		/* User defined file system */
#define	MOUNT_USER4	8		/* User defined file system */
#define	MOUNT_MAXTYPE	8

struct svfs_args {
	char	*fspec;
};
struct ufs_args {
	char	*fspec;
};

#ifdef NFSCLIENT

struct nfs_args {
	struct sockaddr_in	*addr;		/* file server address */
	caddr_t			fh;		/* File handle to be mounted */
	int			flags;		/* flags */
	int			wsize;		/* write size in bytes */
	int			rsize;		/* read size in bytes */
	int			timeo;		/* initial timeout in .1 secs */
	int			retrans;	/* times to retry send */
	char			*hostname;	/* server's hostname */
	int			acregmin;	/* attr cache file min secs */
	int			acregmax;	/* attr cache file max secs */
	int			acdirmin;	/* attr cache dir min secs */
	int			acdirmax;	/* attr cache dir max secs */
	char			*netname;	/* server's netname */
};

/*
 * NFS mount option flags
 */
#define	NFSMNT_SOFT	0x001	/* soft mount (hard is default) */
#define	NFSMNT_WSIZE	0x002	/* set write size */
#define	NFSMNT_RSIZE	0x004	/* set read size */
#define	NFSMNT_TIMEO	0x008	/* set initial timeout */
#define	NFSMNT_RETRANS	0x010	/* set number of request retrys */
#define	NFSMNT_HOSTNAME	0x020	/* set hostname for error printf */
#define	NFSMNT_INT	0x040	/* allow interrupts on hard mount */
#define	NFSMNT_NOAC	0x080	/* don't cache attributes */
#define	NFSMNT_ACREGMIN	0x0100	/* set min secs for file attr cache */
#define	NFSMNT_ACREGMAX	0x0200	/* set max secs for file attr cache */
#define	NFSMNT_ACDIRMIN	0x0400	/* set min secs for dir attr cache */
#define	NFSMNT_ACDIRMAX	0x0800	/* set max secs for dir attr cache */
#define NFSMNT_SECURE	0x1000	/* secure mount */
#define NFSMNT_NOCTO	0x2000	/* no close-to-open consistency */
#define	NFSMNT_POSIX	0x4000	/* static pathconf kludge info */
#endif

#ifdef PCFS
struct pc_args {
	char	*fspec;
};
#endif

#ifdef LOFS
struct lo_args {
	char    *fsdir;
};
#endif

#ifdef KERNEL
  /*
   * mount filesystem type switch table
   */
  extern struct vfsops *vfssw[];
#endif


/*
 * Mount structure.
 * One allocated on every local file system.  
 * Can be used by both SVFS and UFS.
 * Used to find the super block.
 */
struct	mount
{
        struct vfs      *m_vfsp;        /* vfs structure for this filesystem */
        struct buf      *m_bufp;        /* pointer to superblock */
        dev_t           m_dev;          /* device mounted */
        struct vnode    *m_devvp;       /* vnode for block device mounted */
        u_short         m_qflags;       /* QUOTA: filesystem flags */
        struct inode    *m_qinod;       /* QUOTA: pointer to quota file */
        u_long          m_btimelimit;   /* QUOTA: block time limit */
        u_long          m_ftimelimit;   /* QUOTA: file time limit */
};

#ifdef KERNEL
  /*
   * Convert vfs ptr to mount ptr. ONLY WORKS IF m_vfs IS FIRST.
   */
# define VFSTOM(VFSP)  ((struct mount *)(VFSP->vfs_data))

  /*
   * mount table
   */
# if defined(AUTOCONFIG)
    extern struct mount	*mounttab;
# else
    extern struct mount	mounttab[];
# endif

  /*
   * Operations
   */
  struct mount *getmp();
#endif /* KERNEL */

#ifdef RFS

#define MAXDNAME	64		/* Maximum domain name */
struct token {
	int	t_id;	 		/* unique token id */
	char	t_uname[MAXDNAME]; 	/* full domain name of machine */
};

struct rfs_args {
	char    *rmtfs;		/* name of service (fs) */
	struct token *token;	/* identifier of remote mach */
};

/*
 * RFS mount option flags
 */
#define RFS_RDONLY	0x001	/* read-only: passed with remote mount request */
#endif

#endif /* __sys_mount_h */
