#define __need___va_list
#include <stdarg.h>
#if !defined(__stdio_h)
#define __stdio_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:stdio.h	1.23 91/07/09 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */

/*
 * [ANSI C] ANSI X3.159-1989 (4.9) Input/Output
 */

#if !defined(_SIZE_T) && !defined(__size_t__)
# define  _SIZE_T			/* make AT&T happy */
# define  __size_t__			/* make MPW happy */
  typedef unsigned int size_t;
#endif

#if !defined(_FPOS_T) && !defined(__fpos_t__)
# define  _FPOS_T			/* make AT&T happy */
# define  __fpos_t__			/* make MPW happy */
  typedef long fpos_t;
#endif

typedef struct {
    int	     _cnt;
    unsigned char *_ptr;
    unsigned char *_base;
    char     _flag;
    char     _file;
} FILE;

#if !defined(NULL)
# define NULL 0
#endif

#if !defined(EOF)
# define EOF (-1)
#endif

#if !defined(BUFSIZ)
# define BUFSIZ	1024
#endif

#if !defined(_NFILE)
# define _NFILE	128
#endif

/* "whence" values for the lseek() function */
#define SEEK_SET	0		/* from beginning of file */
#define SEEK_CUR	1		/* from current location in file */
#define SEEK_END	2		/* from end of file */

#define FOPEN_MAX	_NFILE		/* max simultaneous open files */
#define FILENAME_MAX	1024		/* max path and filename length */

/*
 * To support both SVR2 and UFS filesystems, temporary filenames are
 * limited to 14-characters max.
 */

#define TMP_MAX		17576		/* max names tmpnam() can generate */

#if (__STDC__ == 1)
# define _P_tmpdir	"/usr/tmp/"
# define L_tmpnam	(sizeof(_P_tmpdir) + 15)
#else
# define P_tmpdir	"/usr/tmp/"
# define L_tmpnam	(sizeof(P_tmpdir) + 15)
#endif

/* buffer size for multi-character output to unbuffered files */
#define _SBFSIZ		8

/* _IOLBF means that a file's output will be buffered line by line
 * In addition to being flags, _IONBF, _IOLBF and _IOFBF are possible
 * values for "type" in setvbuf.
 */
#define _IOFBF		0000
#define _IOREAD		0001
#define _IOWRT		0002
#define _IONBF		0004
#define _IOMYBUF	0010
#define _IOEOF		0020
#define _IOERR		0040
#define _IOLBF		0100
#define _IORW		0200

#define stdin		(&_iob[0])
#define stdout		(&_iob[1])
#define stderr		(&_iob[2])

#define _bufend(p)	_bufendtab[(p)->_file]
#define _bufsiz(p)	(_bufend(p) - (p)->_base)

#if (__STDC__ != 1) || defined(_POSIX_SOURCE)
# define L_ctermid	9
# define L_cuserid	9
#endif

extern FILE	_iob[_NFILE];
extern unsigned char *_bufendtab[];
extern FILE 	*_lastbuf;

#if defined(__STDC__)
  int    remove(const char *__filename);
  int    rename(const char *__old, const char *__new);
  FILE   *tmpfile(void);
  char   *tmpnam(char *__s);
  int    fclose(FILE *__stream);
  int    fflush(FILE *__stream);
  FILE   *fopen(const char *__filename, const char *__mode);
  FILE   *freopen(const char *__filename, const char *__mode, FILE *__stream);
  void   setbuf(FILE *__stream, char *__buf);
  int    setvbuf(FILE *__stream, char *__buf, int __mode, size_t __size);
  int    fprintf(FILE *__stream, const char *__format, ...);
  int    fscanf(FILE *__stream, const char *__format, ...);
  int    printf(const char *__format, ...);
  int    scanf(const char *__format, ...);
  int    sprintf(char *__s, const char *__format, ...);
  int    sscanf(const char *__s, const char *__format, ...);
  int    vfprintf(FILE *__stream, const char *__format, void *__arg);
  int    vprintf(const char *__format, void *__arg);
  int    vsprintf(char *__s, const char *__format, void *__arg);
  int    fgetc(FILE *__stream);
  char   *fgets(char *__s, int __n, FILE *__stream);
  int    fputc(int __c, FILE *__stream);
  int    fputs(const char *__s, FILE *__stream);
  char   *gets(char *__s);
  int    puts(const char *__s);
  int    ungetc(int __c, FILE *__stream);
  size_t fread(void *__ptr, size_t __size, size_t __nmemb, FILE *__stream);
  size_t fwrite(void const *__ptr, size_t __size, size_t __nmemb, FILE *__stream);
  int    fseek(FILE *__stream, long int __offset, int __whence);
  long   ftell(FILE *__stream);
  void   rewind(FILE *__stream);
  void   perror(const char *__s);
  int    getc(FILE *__stream);
  int    getchar(void);
  int    putc(int __c, FILE *__stream);
  int    putchar(int __c);
  void   clearerr(FILE *__stream);
  int    feof(FILE *__stream);
  int    ferror(FILE *__stream);
  int    fgetpos(FILE *__stream, fpos_t *__pos);
  int    fsetpos(FILE *__stream, const fpos_t *__pos);

# if (__STDC__ != 1) || defined(_POSIX_SOURCE)
    int   _filbuf(FILE *__p);
    int   _flsbuf(unsigned char __c, FILE *__p);
    FILE  *popen(const char *__command, const char *__type);
    int   pclose(FILE *__stream);
    FILE  *fdopen(int __fildes, const char *__type);
    char  *ctermid(char *__s);
    char  *cuserid(char *__s);
    char  *tmpnam(char *__s);
    char  *tempnam(char *__dir, char *__pfx);
# endif

#else /* not __STDC__ */

  FILE *fopen();
  FILE *fdopen();
  FILE *freopen();
  FILE *popen();
  FILE *tmpfile();
  long ftell();
  void rewind();
  void setbuf();
  char *ctermid();
  char *cuserid();
  char *fgets();
  char *gets();
  char *tempnam();
  char *tmpnam();

#endif /* __STDC__ */

#if !defined(lint)
# define getc(p)	(--(p)->_cnt < 0 ? _filbuf(p) : (int) *(p)->_ptr++)
# define putc(x, p)	(--(p)->_cnt < 0 ? \
			_flsbuf((unsigned char) (x), (p)) : \
			(int) (*(p)->_ptr++ = (unsigned char) (x)))
# define getchar()	getc(stdin)
# define putchar(x)	putc((x), stdout)
# define clearerr(p)	((void) ((p)->_flag &= ~(_IOERR | _IOEOF)))
# define feof(p)	((p)->_flag & _IOEOF)
# define ferror(p)	((p)->_flag & _IOERR)
# define fileno(p)	(p)->_file
#endif

#endif /* __stdio_h */
