#if !defined(__math_h)
#define __math_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:math.h	1.19 91/07/15 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */

/*
 * Compliant with:
 *   [ANSI C] ANSI X3.159-1989 (4.5) Mathematics
 *   [POSIX]  IEEE Std 1003.1-1988 (8.1) C Language Binding
 */

extern int errno;

#define _ABS(x)	((x) < 0 ? -(x) : (x))
#define _REDUCE(TYPE, X, XN, C1, C2) { \
	double x1 = (double)(TYPE)X, x2 = X - x1; \
	X = x1 - (XN) * (C1); X += x2; X -= (XN) * (C2); }
#define _POLY1(x, c)	((c)[0] * (x) + (c)[1])
#define _POLY2(x, c)	(_POLY1((x), (c)) * (x) + (c)[2])
#define _POLY3(x, c)	(_POLY2((x), (c)) * (x) + (c)[3])
#define _POLY4(x, c)	(_POLY3((x), (c)) * (x) + (c)[4])
#define _POLY5(x, c)	(_POLY4((x), (c)) * (x) + (c)[5])
#define _POLY6(x, c)	(_POLY5((x), (c)) * (x) + (c)[6])
#define _POLY7(x, c)	(_POLY6((x), (c)) * (x) + (c)[7])
#define _POLY8(x, c)	(_POLY7((x), (c)) * (x) + (c)[8])
#define _POLY9(x, c)	(_POLY8((x), (c)) * (x) + (c)[9])

#if defined(__STDC__)

#ifndef HUGE_VAL
#define HUGE_VAL	(1.7976931348623157e+308)
#endif

# if !defined(EDOM)
#   define EDOM		33	/* Math arg out of domain of func	*/
# endif

# if !defined(ERANGE)
#   define ERANGE	34	/* Math result not representable	*/
# endif 

  double acos(double __x);
  double asin(double __x);
  double atan(double __x);
  double atan2(double __y, double __x);
  double cos(double __x);
  double sin(double __x);
  double tan(double __x);
  double cosh(double __x);
  double sinh(double __x);
  double tanh(double __x);
  double exp(double __x);
  double frexp(double __value, int *__exp);
  double ldexp(double __x, int __exp);
  double log(double __x);
  double log10(double __x);
  double modf(double __value, double *__iptr);
  double pow(double __x, double __y);
  double sqrt(double __x);
  double ceil(double __x);
  double fabs(double __x);
  double floor(double __x);
  double fmod(double __x, double __y);

# if (__STDC__ != 1) && !defined(_POSIX_SOURCE)

    double j0(double __x);
    double j1(double __x);
    double jn(int __n, double __x);
    double y0(double __x);
    double y1(double __x);
    double yn(int __n, double __x);
    double erf(double __x);
    double erfc(double __x);
    double gamma(double __x);
    double hypot(double __a, double __b);
    double atof(const char *__nptr);

# endif

#endif /* __STDC__ */

#if (__STDC__ != 1) && !defined(_POSIX_SOURCE)

  extern int signgam;

# define NOEXC		0		/* no exception to report */
# define DOMAIN		1
# define SING		2
# define OVERFLOW	3
# define UNDERFLOW	4
# define TLOSS		5
# define PLOSS		6

  struct exception {
    int type;
    char *name;
    double arg1;
    double arg2;
    double retval;
  };

# if defined(__STDC__)
struct exception;
    int matherr(struct exception *__x);
# endif

  /* some useful constants */
# define M_E		2.7182818284590452354
# define M_LOG2E	1.4426950408889634074
# define M_LOG10E	0.43429448190325182765
# define M_LN2		0.69314718055994530942
# define M_LN10		2.30258509299404568402
# define M_PI		3.14159265358979323846
# define M_PI_2		1.57079632679489661923
# define M_PI_4		0.78539816339744830962
# define M_1_PI		0.31830988618379067154
# define M_2_PI		0.63661977236758134308
# define M_2_SQRTPI	1.12837916709551257390
# define M_SQRT2	1.41421356237309504880
# define M_SQRT1_2	0.70710678118654752440

# if !defined(MINFLOAT)
#   define MINFLOAT	((float) 1.17549435e-38)
# endif

# if !defined(MAXFLOAT)
#   define MAXFLOAT	((float) 3.40282347e+38)
# endif

# if !defined(MINDOUBLE)
#   define MINDOUBLE	(2.2250738585072014e-308)
# endif

# if !defined(MAXDOUBLE)
#   define MAXDOUBLE	(1.7976931348623157e+308)
# endif

# if !defined(HUGE)
#   define HUGE		MAXDOUBLE
# endif

#endif /* __STDC__ != 1 */

#if !defined(__STDC__)

  double acos();
  double asin();
  double atan();
  double atan2();
  double cos();
  double sin();
  double tan();
  double cosh();
  double sinh();
  double tanh();
  double exp();
  double frexp();
  double ldexp();
  double log();
  double log10();
  double modf();
  double pow();
  double sqrt();
  double ceil();
  double fabs();
  double floor();
  double fmod();

# if !defined(_POSIX_SOURCE)

    double atof();
    double j0();
    double j1();
    double jn();
    double y0();
    double y1();
    double yn();
    double erf();
    double erfc();
    double gamma();
    double hypot();
struct exception;
    int    matherr();

# endif

#endif /* !__STDC__ */

#endif /* __math_h */
