
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)atp.h: 2.0, 1.7; 7/10/91; Copyright 1988-89, Apple Computer, Inc. */

/* Definitions for ATP protocol and streams module, per 
 * AppleTalk Transaction Protocol documentation from
 * `Inside AppleTalk', July 14, 1986.
 */


#ifndef __ATP__
#define __ATP__

#ifndef UIOSEG_USER
#if defined(__MPW_C__)
# include "/:usr:include:sys:uio.h"
#else
# include <sys/uio.h>
#endif
#endif


/* DDP ATP protocol type */

#define ATP_DDP_TYPE		0x03	/* ATP packet type */


/* ATP function codes */

#define ATP_CMD_TREQ		0x01	/* TRequest packet  */
#define ATP_CMD_TRESP		0x02	/* TResponse packet */
#define ATP_CMD_TREL		0x03	/* TRelease packet  */


/* Miscellaneous definitions */

#define	ATP_DEF_RETRIES     8	/* Default for maximum retry count */
#define	ATP_DEF_INTERVAL    2	/* Default for retry interval in seconds */

#define ATP_TRESP_MAX       8	/* Maximum number of Tresp pkts */

#define ATP_HDR_SIZE        8  	/* Size of the ATP header */
#define ATP_DATA_SIZE       578  	/* Maximum size of the ATP data area */

/* Consts for asynch support */
#define	ATP_ASYNCH_REQ	1
#define	ATP_ASYNCH_RESP	2

/* Timer values for XO release timers */
#define	ATP_XO_DEF_REL_TIME	0
#define	ATP_XO_30SEC		0
#define	ATP_XO_1MIN		1
#define	ATP_XO_2MIN		2
#define	ATP_XO_4MIN		3
#define	ATP_XO_8MIN		4

typedef struct {
#if defined(__vax__) || defined(sequent) || defined(__sun386__)
        u_char         xo_relt : 3,
                       sts : 1,
                       eom : 1,
                       xo : 1,
                       cmd : 2;
#else
        u_char         cmd : 2,
                       xo : 1,
                       eom : 1,
                       sts : 1,
                       xo_relt : 3;
#endif
        u_char         bitmap;
	u_short        tid;
        u_long         user_bytes;
        u_char         data[ATP_DATA_SIZE];
} at_atp_t;


/* Response buffer structure for atp_sendreq() and atp_sendrsp() */

typedef	struct	at_resp {
	u_char	bitmap;				/* Bitmap of responses */
	struct	iovec resp[ATP_TRESP_MAX];	/* Buffer for response data */
	long	userdata[ATP_TRESP_MAX];	/* Buffer for response user data */
} at_resp_t;

#endif
