/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)asp_cb.h: 2.0, 1.7; 7/10/91; Copyright 1988-89, Apple Computer, Inc. */

#ifndef __ASPCB__
#define __ASPCB__

/* ??? - stream parameter block and CCB should be merged to avoid
 * unpacking and re-packing of parameters in aspstream.c.  See atp
 * for example.  SCB should use unions to avoid wasted space for
 * different socket types.
 */

#if defined(__MPW_C__)
# include "/:usr:include:at:atp.h"
#else
# include <at/atp.h>
#endif
#if defined(__MPW_C__)
# include "/:usr:include:at:atp_cb.h"
#else
# include <at/atp_cb.h>
#endif

/* ASP definitions */

/* Socket types */
#define ASP_SCBTYPE_IDLE	1	/* Socket is an uninitialized ASP socket */
#define ASP_SCBTYPE_WSS		2	/* Socket is a Workstation Session Socket */
#define ASP_SCBTYPE_SLS		4	/* Socket is a Session Listining Socket */
#define ASP_SCBTYPE_SSS		8	/* Socket is a Server Session Socket */

/* Socket states */
#define ASP_SCBSTATE_IDLE	1	/* Socket is an uninitialized ASP socket */
#define ASP_SCBSTATE_LISTEN	2	/* Socket is a SSS waiting for an OpenSess */
#define ASP_SCBSTATE_OPENING	4	/* ASP WSS socket waiting for OpenSess reply */
#define ASP_SCBSTATE_OPEN	8	/* ASP socket is fully open */
#define ASP_SCBSTATE_CLOSING	16	/* ASP socket is closing 
					 * (will close on next user req) */

/*
 * ASP Socket Control Block (SCB).
 *
 * A SCB is created whenever a client opens an ASP socket.
 * The SCB maintains, on a per socket basis, private socket data
 * structures and a queue of outstanding ASP User Requests.
 */
struct SCB {
   struct SCB 	*FwdLink;
   struct SCB 	*BwdLink;
   struct SCB	*SLSLink;		/* Back-pointer to our SLS */
   char 	*AtpOpaquePtr;		/* Pointer to ATP's opaque data */
   MEM_T 	*mp;			/* MEM_T pointer for this SCB */
   int		AsyncError;		/* Error code of asynchronous errors */
   u_short	Attn;			/* Attention data */
   u_char	SessID;			/* ASP Session ID */
   int		LastSeq;		/* ASP LastReqNum */
   at_inet_t	NetAddr;		/* Internet addr of remote endpoint */
   at_inet_t	SLSNetAddr;		/* WSS Only: Internet address of SLS */
   int		State;			/* socket state (OPEN, etc...) */
   int		Type;			/* socket type (WSS, SLS, SSS, IDLE) */
   at_socket 	Skt; 	                /* Socket to receive request on */
   int		TickleTimer;		/* Timer ID of session tickle timer */
   at_aspstat_t	Stats;			/* Session round trip time, timeout, etc. */
   MEM_T	*StatusBufMp;		/* Server status block */
   int		StatusLen;
   /* Queue of our listening SSS sockets (SLS only) */
   struct SCB	*LisSCBFwdLink;			
   struct SCB	*LisSCBBwdLink;
   /* Queue of our connected SSS sockets (SLS only) */
   struct SCB	*ConnSCBFwdLink;			
   struct SCB	*ConnSCBBwdLink;
   /* Queue of pending User requests */
   struct CCB	*RqFwdLink;
   struct CCB	*RqBwdLink;
   /* Queue of pending Write requests (SSS pnly) */
   struct CCB	*WrFwdLink;
   struct CCB	*WrBwdLink;
   u_long	(*GetSessComp)(),
		GetSessParam;		/* Need this for SSS completion */
   u_long	(*AttnComp)(),
		AttnParam;		/* Need this for WSS Attn completion */
};



/*
 * ASP Command Control Block (CCB).
 *
 * The CCB maintains the context of an ASP Request issued by
 * an ASP user request.  A queue of pending requests is maintained
 * on a per ASP socket basis.  This allows for multiple requests to 
 * be issued asynchronously by an ASP user.  The CCB queue head 
 * extends from the SCB. 
 */

/* CCB types */
#define ASP_CCBTYPE_SENDREQ	1
#define ASP_CCBTYPE_GETREQ	2
#define ASP_CCBTYPE_SENDRESP	4

struct CCB {
   struct CCB 	*FwdLink;
   struct CCB 	*BwdLink;
   struct SCB	*SCBPtr;	/* Link to this request's socket struct */
   MEM_T	*mp;		/* MEM_T ptr for this struct's memory blk */
   AtpRB_t	Atp;		/* ATP parameters for this request */
   u_long	Status;		/* Status of request */
   u_char	Type; 		/* Type of this CCB */
   u_char	*ReqType; 	/* Incoming SSS request type */
   u_short	*ReqId; 	/* Incoming SSS request id */
   u_long	*CmdResult;	/* WSS only: -> result of Command request */
   MEM_T	**GetReqMpPtr; 	/* Pointer to user's ReqMp for GetReq */
   int		*GetReqLenPtr; 	/* Pointer to user's ReqLen for GetReq */
   MEM_T	**ReplyMpPtr;	/* -> Reply buffer MEM_T or NULL for no reply */
   int		*ReplyLen;	/* Expected reply len & -> Actual len of reply */
   MEM_T	*WriteMp;	/* Write buffer */
   int		*WriteLen;	/* Length of write buffer, short because of
				   WriteData ??? */
   void		(*SendReqCompletion)();	
				/* Completion routine for a completed ATP send req */
   int 		(*Completion)();/* ASP caller's request completion routine */
   u_long 	CParam;   	/* Completion routine parameter */
};

/*
 * ASP Socket Control Block (SCB) Queue Heads.
 */
extern struct SCB SCBQueHd;



#define	ASP_IOC_MYIOCTL(i)	((i>>8) == AT_MID_ASP)
/* Shared requests */
#define	ASP_IOC_GET_PARMS	((AT_MID_ASP<<8) | 0)
#define	ASP_IOC_GET_INFO	((AT_MID_ASP<<8) | 1)
/* Server requests */
#define	ASP_IOC_INIT		((AT_MID_ASP<<8) | 2)
#define	ASP_IOC_GET_SESS	((AT_MID_ASP<<8) | 3)
#define	ASP_IOC_GET_SCB		((AT_MID_ASP<<8) | 4)
#define	ASP_IOC_GET_REQ		((AT_MID_ASP<<8) | 5)
#define	ASP_IOC_CMD_REPLY	((AT_MID_ASP<<8) | 6)
#define	ASP_IOC_WR_CONT		((AT_MID_ASP<<8) | 7)
#define	ASP_IOC_WR_REPLY	((AT_MID_ASP<<8) | 8)
#define	ASP_IOC_NEW_STAT	((AT_MID_ASP<<8) | 9)
#define	ASP_IOC_ATTN		((AT_MID_ASP<<8) | 10)
/* 'Workstation' requests */
#define	ASP_IOC_GET_STAT	((AT_MID_ASP<<8) | 20)
#define	ASP_IOC_OPEN_SESS	((AT_MID_ASP<<8) | 21)
#define	ASP_IOC_GET_ATTN	((AT_MID_ASP<<8) | 22)
#define	ASP_IOC_COMMAND		((AT_MID_ASP<<8) | 23)
#define	ASP_IOC_WRITE		((AT_MID_ASP<<8) | 24)

/* The asp ioctl command structure, whereby asp user commands are passed
 * to and from the streams module.
 */

struct	aspcmd	{
    /* These fields are not used by the caller, they are only a holding 
     * space for the ASP protocol code to use.
     */
    caddr_t		ioc;		/* streams ioc message pointer */
    caddr_t		q;		/* streams write q */
    int			result;

    /* These fields are used to send/recv user requests between the caller
     * and the ASP protocol code.
     */
    at_inet_t	 	dest;		/* internet address of remote endpoint */
    int			maxcmd,		/* ASP maxcmd and quantum parameters */
			quantum;
    at_retry_t		retry;		/* GetStat, OpenSess, and Attn retry spec. */
    char		*SCBPtr;	/* SCBPtr for linking SLS and SSS */
    mblk_t		*status_mp;	/* mblk containing status data */
    int			status_len;	/* length of status data */
    mblk_t		*buf_mp;	/* mblk for cmd data */
    int			buf_len;	/* length of command buf/data */
    mblk_t		*write_mp;	/* mblk for write data */
    int			write_len;	/* length of write data */
    mblk_t		*reply_mp;	/* mblk for cmd reply */
    int			reply_len;	/* length of command reply */
    u_short		attn_code;	/* attention code */
    u_short		req_id;		/* command request id */
    u_long		req_result;	/* command result */
    u_char		req_type;	/* command request type */
    u_char		filler[2];

    char		data[1];	/* Appended data starts here */
};

#endif

