
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)appletalk.h: 2.0, 1.6; 7/10/91; Copyright 1988-89, Apple Computer, Inc. */

/* Miscellaneous definitions for AppleTalk used by all protocol 
 * modules.
 */

#ifndef __APPLETALK__
#define __APPLETALK__

#if defined(__MPW_C__)
# include "/:usr:include:sys:types.h"
#else
# include <sys/types.h>
#endif

/* Miscellaneous types */

typedef u_short	at_net;			/* AppleTalk network number */
typedef u_char	at_node;		/* AppleTalk node number */
typedef u_char  at_socket;		/* AppleTalk socket number */


/* AppleTalk Internet Address */

typedef struct at_inet {
    at_net	net;			/* Network Address */
    at_node	node;			/* Node number */
    at_socket	socket;			/* Socket number */
} at_inet_t;


/* AppleTalk protocol retry and timeout */

typedef struct at_retry {
    short	interval;		/* Retry interval in seconds */
    short	retries;		/* Maximum number of retries */
    u_char      backoff;                /* Retry backoff, must be 1 through 4 */
} at_retry_t;

#define	AT_INF_RETRY	-1		/* Retry forever */

#endif

