#ifndef __GCC_GOT_time_h_
#define __GCC_GOT_time_h_
#if !defined(__time_h)
#define __time_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:time.h	1.15 91/06/02 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */

/*
 * Compliant with:
 *   [ANSI C] ANSI X3.159-1989 (4.12) Date and Time
 */

#if !defined(CLOCKS_PER_SEC)
# define CLOCKS_PER_SEC	100
#endif

#if !defined(NULL)
# define NULL 0
#endif

#if !defined(_CLOCK_T) && !defined(__clock_t__)
# define  _CLOCK_T			/* make AT&T happy */
# define  __clock_t__			/* make MPW happy */
  typedef long clock_t;
#endif

#if !defined(_TIME_T) && !defined(__time_t__)
# define  _TIME_T			/* make AT&T happy */
# define  __time_t__			/* make MPW happy */
  typedef long time_t;
#endif

#if !defined(_SIZE_T) && !defined(__size_t__)
# define  _SIZE_T			/* make AT&T happy */
# define  __size_t__			/* make MPW happy */
  typedef unsigned int size_t;
#endif

/*
 * Date and time functions
 */
struct	tm {	/* see ctime(3) */
	int	tm_sec;
	int	tm_min;
	int	tm_hour;
	int	tm_mday;
	int	tm_mon;
	int	tm_year;
	int	tm_wday;
	int	tm_yday;
	int	tm_isdst;
};

#if defined(__STDC__)

  clock_t clock(void);
  double  difftime(time_t time1, time_t time0);
  time_t  mktime(struct tm *timeptr);
  time_t  time(time_t *timer);
  char    *asctime(const struct tm *timeptr);
  char    *ctime(const time_t *timer);
  struct tm *gmtime(const time_t *timer);
  struct tm *localtime(const time_t *timer);
  size_t  strftime(char *s, size_t maxsize, const char *format,
            const struct tm *timeptr);

#else /* ! __STDC__ */

  clock_t clock();
  time_t  time();
  char    *ctime();
  char    *asctime();
  struct tm *gmtime();
  struct tm *localtime();

#endif /* __STDC__ */

#if defined(_SYSV_SOURCE) || defined(_BSD_SOURCE) || defined(_POSIX_SOURCE)
  void tzset();
#endif /* _SYSV_SOURCE || _BSD_SOURCE || _POSIX_SOURCE */

#if defined(_SYSV_SOURCE) || defined(_POSIX_SOURCE)
  extern char *tzname[];
#endif /* _SYSV_SOURCE || _POSIX_SOURCE */

#if defined(_SYSV_SOURCE)
  extern long timezone;
  extern int daylight;
#endif /* _SYSV_SOURCE */

#if defined(_POSIX_SOURCE)
# if !defined(CLK_TCK)
#   define CLK_TCK	60
# endif /* !CLK_TCK */
#endif /* _POSIX_SOURCE */

#endif /* __time_h */
#endif /* !_GCC_GOT_time_h_ */
