#if !defined(__sys_wait_h)
#define __sys_wait_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/wait.h	1.8 91/07/10 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-90 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

#if defined(__MPW_C__)
# include "/:usr:include:sys:types.h"
#else
# include <sys/types.h>
#endif

#ifdef _BSD_SOURCE
/* Copyright 1980-87 The Regents of the University of California */

/*
 * This file holds definitions relevent to the wait system call.
 * Some of the options here are available only through the ``wait3''
 * entry point; the old entry point with one argument has more fixed
 * semantics, never returning status of unstopped children, hanging until
 * a process terminates if any are outstanding, and never returns
 * detailed information about process resource utilization (<vtimes.h>).
 */

/*
 * Structure of the information in the first word returned by both
 * wait and wait3.  If w_stopval==WSTOPPED, then the second structure
 * describes the information returned, else the first.  See WUNTRACED below.
 */
union wait	{
	int	w_status;		/* used in syscall */
	/*
	 * Terminated process status.
	 */
	struct {
		unsigned short		:16;
		unsigned short	w_Retcode:8;	/* exit code if w_termsig==0 */
		unsigned short	w_Coredump:1;	/* core dump indicator */
		unsigned short	w_Termsig:7;	/* termination signal */
	} w_T;
	/*
	 * Stopped process status.  Returned
	 * only for traced children.
	 */
	struct {
		unsigned short		:16;
		unsigned short	w_Stopsig:8;	/* signal that stopped us */
		unsigned short	w_Stopval:8;	/* == W_STOPPED if stopped */
	} w_S;
};
#define	w_termsig	w_T.w_Termsig
#define w_coredump	w_T.w_Coredump
#define w_retcode	w_T.w_Retcode
#define w_stopval	w_S.w_Stopval
#define w_stopsig	w_S.w_Stopsig


#define	WSTOPPED	0177	/* value of s.stopval if process is stopped */

#define WIFSTOPPED(x)	((x).w_stopval == WSTOPPED)
#define WIFSIGNALED(x)	((x).w_stopval != WSTOPPED && (x).w_termsig != 0)
#define WIFEXITED(x)	((x).w_stopval != WSTOPPED && (x).w_termsig == 0)

#endif /* _BSD_SOURCE */

#ifdef _POSIX_SOURCE

/*
 * protect ourselves from _BSD_SOURCE definitions
 */
#ifdef WIFSTOPPED
#undef WIFSTOPPED
#endif
#ifdef WIFSIGNALED
#undef WIFSIGNALED
#endif
#ifdef WIFEXITED
#undef WIFEXITED
#endif

#define WIFEXITED(status)	(!((status) & 0377))
#define WEXITSTATUS(status)	(((status) >> 8) & 0377)
#define WIFSIGNALED(status)	(!(((status) >> 8) & 0377) && ((status) & 0177))
#define WTERMSIG(status)	((status) & 0177)
#define WIFSTOPPED(status)	(((status) & 0177) == 0177)
#define WSTOPSIG(status)	(((status) >> 8) & 0177)

#if defined(__STDC__)
pid_t wait(int *status);
pid_t waitpid(pid_t pid, int *status, int options);
#else
pid_t wait(), waitpid();
#endif /* __STDC__ */

#endif /* _POSIX_SOURCE */

/*
 * Option bits for the second argument of wait3 (derived from BSD) and the
 * third argument of waitpid (defined by POSIX).  WNOHANG causes the
 * wait to not hang if there are no stopped or terminated processes, rather
 * returning an error indication in this case (pid==0).  WUNTRACED
 * indicates that the caller should receive status about untraced children
 * which stop due to signals.  If children are stopped and a wait without
 * this option is done, it is as though they were still running... nothing
 * about them is returned.
 */
#define WNOHANG		1	/* dont hang in wait */
#define	WUNTRACED	2	/* tell about stopped, untraced children */

#endif /* __sys_wait_h */
