#if !defined(__sys_types_h)
#define __sys_types_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/types.h	1.17 91/06/02 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */
/* Copyright 1983-87 Sun Microsystems, Inc. */

/* NFSSRC 2.2 86/05/15 */

#define _TYPES_		/* for backwards compatibility */

/*
 * System-dependent parameters and types
 */

typedef	char *		caddr_t;
typedef short		cnt_t;
typedef	long		daddr_t;
typedef	unsigned short	dev_t;
typedef int		gid_t;
typedef	long		key_t;
typedef	int		label_t[13];
typedef unsigned short	mode_t;
typedef short		nlink_t;
typedef	long		off_t;
typedef	long		paddr_t;

#if !defined(_PID_T) && !defined(__pid_t__)
# define  _PID_T			/* make AT&T happy */
# define  __pid_t__			/* make MPW happy */
  typedef int		pid_t;
#endif

#if defined(_POSIX_SOURCE)
  typedef unsigned long	ino_t;
#else
  typedef unsigned short ino_t;
#endif

#if !defined(_CLOCK_T) && !defined(__clock_t__)
# define  _CLOCK_T			/* make AT&T happy */
# define  __clock_t__			/* make MPW happy */
  typedef long		clock_t;
#endif

#if !defined(_PTRDIFF_T) && !defined(__ptrdiff_t__)
# define  _PTRDIFF_T			/* make AT&T happy */
# define  __ptrdiff_t__			/* make MPW happy */
#ifndef __PTRDIFF_TYPE__
#define __PTRDIFF_TYPE__ long int
#endif
  typedef __PTRDIFF_TYPE__ ptrdiff_t;
#endif

#if !defined(_SIZE_T) && !defined(__size_t__)
# define  _SIZE_T			/* make AT&T happy */
# define  __size_t__			/* make MPW happy */
# if defined(__STDC__)
#ifndef __SIZE_TYPE__
#define __SIZE_TYPE__ long unsigned int
#endif
#ifndef _GCC_SIZE_T
#define _GCC_SIZE_T
    typedef __SIZE_TYPE__ size_t;
#endif
# else
#ifndef __SIZE_TYPE__
#define __SIZE_TYPE__ long unsigned int
#endif
#ifndef _GCC_SIZE_T
#define _GCC_SIZE_T
    typedef __SIZE_TYPE__ size_t;
#endif
# endif
#endif

#if !defined(_WCHAR_T) && !defined(__wchar_t__)
# define  _WCHAR_T			/* make AT&T happy */
# define  __wchar_t__			/* make MPW happy */
#ifndef __WCHAR_TYPE__
#define __WCHAR_TYPE__ int
#endif
#ifndef __cplusplus
  typedef __WCHAR_TYPE__ wchar_t;
#endif
#endif

#if !defined(_TIME_T) && !defined(__time_t__)
# define  _TIME_T			/* make AT&T happy */
# define  __time_t__			/* make MPW happy */
  typedef long time_t;
#endif

#if !defined(NULL)
# define NULL 0
#endif

typedef int		ssize_t;
typedef	long		ubadr_t;	/* physical unibus address */
typedef	unsigned char	uchar_t;
typedef	unsigned short	ushort_t;
typedef int		uid_t;
typedef	unsigned int	uint_t;
typedef	unsigned long	ulong_t;

/*
 * To be excluded from visibility control, types must end in _t.
 */

#ifdef _SYSV_SOURCE
  typedef unsigned int	uint;
  typedef unsigned long	ulong;
  typedef unsigned char	unchar;
  typedef unsigned short ushort;
#endif /* _SYSV_SOURCE */

#ifdef _BSD_SOURCE
  typedef struct{int r[1];} *physadr;
  typedef struct _quad { long val[2]; } quad;
  typedef unsigned char	u_char;
  typedef unsigned short u_short;
  typedef unsigned int	u_int;
  typedef unsigned long	u_long;

/*
 * Select uses bit masks of file descriptors in longs.  These macros
 * manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here should
 * be >= NOFILE (param.h).
 */
#ifndef	FD_SETSIZE
#define	FD_SETSIZE	128
#endif

#define	NBBY	          8		/* number of bits in a byte */

typedef long	fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */

#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif

typedef	struct fd_set {
	fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define	FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))

#endif /* _BSD_SOURCE */

#ifdef _AUX_SOURCE
  typedef unsigned long	ino_tl;
#endif /* _AUX_SOURCE */

#endif /* __sys_types_h */
