#if !defined(_NO_IDENTS) && defined(_MISC_IDENTS)
# pragma ident "@(#)head:sys/c94.h 1.1 92/12/11 "
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* NCR 53c94/Emulex ESP216 SCSI manager */

#ifndef min
#define min(x,y) ((x) < (y)) ? (x) : (y)
#endif

#define NC94 4

#define splc94 spl2

#define MAXLOOP 1000000
#define NOIRQ	-1
#define WAIT	1
#define NOWAIT	0

typedef void (*pfv)();			/* pointer to func returning void */

struct	c94tasks {
    struct scsireq *req;	/* user's request */
    long	devchar;	/* device characteristics */
    caddr_t	cmdbuf;		/* Current command */
    int		cmdlen;		/* Length of the command */
    caddr_t	databuf;	/* data buffer */
    int		datalen;	/* size of data area */
    int		datasent;	/* Data read so far */
    int		niovsent;	/* Num iov-s sent */
    int		dmacount;	/* current bytecount being hardware-DMA'ed */
    int		dmadone;	/* bytecount already software-DMA'ed this req */
    caddr_t	dmabuf;		/* current buffer    being hardware-DMA'ed */
    int		iovsegcnt;	/* bytes remaining this iov segment */
    short	maxtime;	/* limit on time for this task */
    short	curtime;	/* current time running on this task */
    u_char	flags;		/* task flags */
    u_char	lun;		/* logical unit number */
};

/*	SCSI task flags
 *	    These flags modify the state.  They are one bit flags.
 */

#define	SF_JOB		0x01		/* There is a job for this ID */
#define	SF_SENSE	0x02		/* trying to start auto sense */
#define	SF_READ		0x04		/* Data direction of command is read */
#define	SF_RUN		0x08		/* The task has begun to run */
#define	SF_TRACE  	0x10		/* Trace this job         */
#define	SF_TRACEPR	0x20		/* Print trace on console */

struct context {			/* per SCSI bus/chip */
    struct c94		*addr;		/* chip address */
    u_long		*dreq;		/* DREQ status address */
    u_long		dreqmask;	/* mask to get DREQ status bit */
    struct cdma		*dma;		/* DMA controller channel address */
    pfv			irq;		/* interrupt analyzer/action */
    struct c94tasks	*curstp;
    struct c94tasks	*stuck;		/* culprit on bus hang */
    short		state;
    short		curid;
    short		lastid;		/* last id checked in choose */
    short		chipclk;	/* chip clock input in MHz */
    u_char		flags;		/* flags */
    u_char 		discjobs;	/* bitmap of disconnected IDs */
    u_char		intr;		/* interrupt     reg saved at IRQ */
    u_char		stat;		/* status        reg saved at IRQ */
    u_char		seqstep;	/* sequence-step reg saved at IRQ */
    struct c94tasks	tasks[8];
    struct scsig0cmd	sense[8];	/* auto-sense commands */
};

#define SG_IDLE		1
#define	SG_WRECON	2
#define	SG_RUN		3
#define SG_WIRQ		4
#define	SG_WRESET	5

#define	SF_HWDMA	0x01		/* we have h/w dma */

/*
 * Note: Within source files, functions are arranged roughly in order of
 * execution: that is, "ixxx" is the interrupt-handler executed after
 * a function starts a command. Such a function will generally appears
 * below the function that kicks it off.
 */

void	c94_abort();
void	c94_callback();
void	c94_cmd();
int	c94_cmdwent();
void	c94_copyreq();
void	c94_in();
void	c94_initchip();
void	c94_notify();
void	c94_out();
void	c94_phase();
void	c94_reset();
void	c94_reselect();
void	c94_select();
void	c94_start();
void	c94_status();

char	*c94_decodestat();
char	*c94_decodeirq();
char	*c94_tracescpy();
char	*c94_traceltod();
char	*c94_traceltox();
char	*c94_tracescpy();
char	*c94_tracesncpy();
char	*c94_tracestox();
