#if !defined(__net_netisr_h)
#define __net_netisr_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:net/netisr.h	1.6 90/09/07 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987, 1988, 1989 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1983-87 Sun Microsystems, Inc. */
/* Copyright 1980-87 The Regents of the University of California */

/*
 * The networking code runs off software interrupts.
 *
 * You can switch into the network by doing splnet() and return by splx().
 * The software interrupt level for the network is higher than the software
 * level for the clock (so you can enter the network in routines called
 * at timeout time).
 */

/*
 * These definitions are only to provide compatibility
 * with old code; new stuff should use softcall directly
 */
#define	schednetisr(isrname)	softcall(isrname, (caddr_t)0)

#define	NETISR_RAW	rawintr		/* raw net intr */
#define	NETISR_IP	ipintr		/* IP net intr */
#define	NETISR_NS	nsintr		/* NS net intr */
#define NETISR_ET	etintr		/* ethertalk net intr */

int rawintr();

#ifdef INET
int ipintr();
#endif

#ifdef NS
int nsintr();
#endif

#endif /* __net_netisr_h */
