
/*
 *	Copyright (c) 1988, 1989 Apple Computer, Inc. 
 *
 *	The information contained herein is subject to change without
 *	notice and  should not be  construed as a commitment by Apple
 *	Computer, Inc. Apple Computer, Inc. assumes no responsibility
 *	for any errors that may appear.
 *
 *	Confidential and Proprietary to Apple Computer, Inc.
 */

/* @(#)asp.h: 2.0, 1.3; 7/14/89; Copyright 1988-89, Apple Computer, Inc. */

/* Definitions for AppleTalk Session protcol (ASP), per AppleTalk Session Protocol
 * documentation from `Inside AppleTalk', July 14, 1986.
 */

#ifndef __ASP__
#define __ASP__


/* ASP packet types */

#define	ASP_CMD_CLOSESESS	1
#define	ASP_CMD_COMMAND	2
#define	ASP_CMD_GETSTAT	3
#define	ASP_CMD_OPENSESS	4
#define	ASP_CMD_TICKLE	5
#define	ASP_CMD_WRITE	6
#define	ASP_CMD_WRITEDATA	7
#define	ASP_CMD_ATTN		8


/* ASP error codes */

#define ASP_ERR_BADVERS	0xfbd6	/* Client/Server ASP version mismatch */
#define ASP_ERR_SERVBUSY	0xfbd1	/* ASP Server is busy (no GetSessions) */


/* Misc. ASP definitions */

#define ASP_PROTO_VERS	0x100	/* ASP protocol version */

#define ASP_TICKLE_TIMER	30
#define ASP_MAX_TICKLE	4 


/* ASP status block */

typedef struct	at_aspstat {
	int	num_req;		/* Number of ATP requests sent */
	int	num_bad_req;		/* Number of ATP request errors */
	int	num_retrans;		/* Number of ATP request retransmissions */
	int	num_resp;		/* Number of ATP responses sent */
	int	num_bad_resp;		/* Number of ATP response errors */
	long	Rtt;			/* Last round trip time */
	short	Rto;			/* Current retransmit timeout */
	short	Srtt;			/* Smoothed round trip time */
	short	Rttv;			/* Round trip time variance */
} at_aspstat_t;

#endif

